				;
				;***** UART_Interrupt
				;
				;     protocol:   <AA><xx><xx><7E><f5:f6><f3:f4><f1:f2><ch1:ch2>
				;     xx: don't care
				;     fx: frequency - 3 bytes - BCD coding
				;     chx: channel - 1 byte - BCD coding
				;     6 digit dispay: " f1:f2:f3.f4:f5:f6"
				;     <AA><xx><xx><7E><56><34><12><78>  -> " 123.456" and "  Ch 78 "
				;     if f5 > 7: special function, displays "A 234 56" instead of "823.456"
				;	  and "A Ch 78 " instead of "  Ch 78 "
				;     if ch1:ch2 = 00 -> channel is not displayed, push-button has no effect
				;
072C			UART_Interrupt:

072C : C0 E0			push	acc
072E : C0 D0			push	psw
0730 : 75 D0 08			mov		psw,#008H			; RS0=1 -> bank 1
0733 : 20 98 03			jb		ri,L0739
0736 : 02 07 9B			ljmp	End_Uart_Irq
						;
0739				L0739:
0739 : AF 99			mov		r7,sbuf
073B : C2 98			clr		ri
073D : E5 3B			mov		a,Field2_Flag_A
073F : 70 39			jnz		Uart_Irq_F2			; jump to second field acquisition if 1
0741 : EF				mov		a,r7
0742 : B4 AA 0A			cjne	a,#0AAH,L074F
						;
						; AA header received -> initialisation
						;
0745 : 75 63 00			mov		Rx_Index_A,#000H
0748 : 8F 2B			mov		Rx_Buffer_A,r7		; save AA to buffer
074A : 75 63 01			mov		Rx_Index_A,#001H
074D : 80 4C			sjmp	End_Uart_Irq
				;
074F				L074F:
074F : E5 63			mov		a,Rx_Index_A		; X0063
0751 : 24 FC			add		a,#0FCH
0753 : 40 46			jc		End_Uart_Irq		; jump if Rx_Index_A > 3

0755 : E5 63			mov		a,Rx_Index_A
0757 : 24 2B			add		a,#Rx_Buffer_A		; start buffer reception
0759 : F9				mov		r1,a
075A : A7 0F			mov		@r1,R7_1			; save R7 to buffer
075C : 05 63			inc		Rx_Index_A

075E : E5 63			mov		a,Rx_Index_A
0760 : B4 04 38			cjne	a,#004H,End_Uart_Irq

0763 : E5 2B			mov		a,Rx_Buffer_A
0765 : B4 AA 0A			cjne	a,#0AAH,L0772		; initialisation if first character <> AA

0768 : E5 2E			mov		a,Rx_Buffer_A+3
076A : B4 7E 05			cjne	a,#07EH,L0772		; initialisation if 4th character <> 7E

						; 1st character=AA and 4th character=7E
						
076D : 75 3B 01			mov		Field2_Flag_A,#1	; second field flag validated
0770 : 80 29			sjmp	End_Uart_Irq
				;
0772				L0772:
0772 : 75 63 00			mov		Rx_Index_A,#0
0775 : 75 3B 00			mov		Field2_Flag_A,#0
0778 : 80 21			sjmp	End_Uart_Irq
				;
077A				Uart_Irq_F2:
						;
						; 2nd field acquisition
						;
077A : E5 63			mov		a,Rx_Index_A
077C : 24 F9			add		a,#0F9H
077E : 40 0B			jc		L078B				; jump if Rx_Index_A >= 7
0780 : E5 63			mov		a,Rx_Index_A
0782 : 24 2B			add		a,#Rx_Buffer_A
0784 : F9				mov		r1,a
0785 : A7 0F			mov		@r1,R7_1			; copy R7 to buffer
0787 : 05 63			inc		Rx_Index_A
0789 : 80 10			sjmp	End_Uart_Irq
				;
078B				L078B:
078B : E5 63			mov		a,Rx_Index_A
078D : 24 2B			add		a,#Rx_Buffer_A
078F : F9				mov		r1,a
0790 : A7 0F			mov		@r1,R7_1			; copy R7 to buffer
0792 : 75 3C 00			mov		Wait_Data_A,#000H
0795 : 75 3B 00			mov		Field2_Flag_A,#000H
0798 : 75 63 00			mov		Rx_Index_A,#000H
079B				End_Uart_Irq:
079B : D0 D0			pop		psw
079D : D0 E0			pop		acc
079F : 32				reti