				;
				;***** INT1 interrupt
				;		82C52 external UART
				;
07A0			INT1_Interrupt:

07A0 : C0 E0			push	acc
07A2 : C0 82			push	dpl
07A4 : C0 83			push	dph
07A6 : C0 D0			push	psw
07A8 : 75 D0 08			mov		psw,#008H			; bank 1
07AB : 90 C0 00			mov		dptr,#0C000H
07AE : E0				movx	a,@dptr				; get data from 82C52
07AF : FF				mov		r7,a				; R7 = data received (bank 1, address 0F)

07B0 : E5 3D			mov		a,Field2_B			; X003D
07B2 : 70 39			jnz		L07ED

07B4 : EF				mov		a,r7
07B5 : B4 AA 0A			cjne	a,#0AAH,L07C2		; data = AA ?
						; a=AA
07B8 : 75 64 00			mov		Rx_Index_B,#000H
07BB : 8F 33			mov		Rx_Buffer_B,r7		; R7=AA -> saved to buffer (0033)
07BD : 75 64 01			mov		Rx_Index_B,#001H
07C0 : 80 4C			sjmp	L080E				; end of routine
				;
07C2				L07C2:
						; a <> AA
07C2 : E5 64			mov		a,Rx_Index_B		; X0064
07C4 : 24 FC			add		a,#0FCH				; Index = 0..3
07C6 : 40 46			jc		L080E				; jump if index > 3
07C8 : E5 64			mov		a,Rx_Index_B		; X0064
07CA : 24 33			add		a,#Rx_Buffer_B		; 33h = base address of receive buffer
07CC : F9				mov		r1,a
07CD : A7 0F			mov		@r1,R7_1			; (X000F=R7) = data received (= mov @R1,R7 in bank 1)
07CF : 05 64			inc		Rx_Index_B
07D1 : E5 64			mov		a,Rx_Index_B
07D3 : B4 04 38			cjne	a,#004H,L080E		; index=4 -> end of first part

07D6 : E5 33			mov		a,Rx_Buffer_B		; X0033
07D8 : B4 AA 0A			cjne	a,#0AAH,L07E5		; Header = AA ? (33,34,35,36)

07DB : E5 36			mov		a,Rx_Buffer_B+3		; 4th character = 7E ? X0036
07DD : B4 7E 05			cjne	a,#07EH,L07E5		; bad character -> reset index

						; second field of transmission
						
07E0 : 75 3D 01			mov		Field2_B,#001H		; ok
07E3 : 80 29			sjmp	L080E
				;
07E5				L07E5:

						; 2nd Header wrong -> reset
						
07E5 : 75 64 00			mov		Rx_Index_B,#000H	; init index
07E8 : 75 3D 00			mov		Field2_B,#000H		; 1st field
07EB : 80 21			sjmp	L080E
				;
07ED				L07ED:
						;
						;***** Field2_B=1
						;
07ED : E5 64			mov		a,Rx_Index_B
07EF : 24 F9			add		a,#0F9H				
07F1 : 40 0B			jc		L07FE				; jump if Rx_Index_B > 6
07F3 : E5 64			mov		a,Rx_Index_B		; X0064
07F5 : 24 33			add		a,#Rx_Buffer_B		; 033H
07F7 : F9				mov		r1,a
07F8 : A7 0F			mov		@r1,R7_1			; copy R7 to buffer
07FA : 05 64			inc		Rx_Index_B
07FC : 80 10			sjmp	L080E
				;
07FE				L07FE:

						; Rx_Index_B > 6
						
07FE : E5 64			mov		a,Rx_Index_B		; X0064
0800 : 24 33			add		a,#Rx_Buffer_B		; 033H
0802 : F9				mov		r1,a
0803 : A7 0F			mov		@r1,R7_1			; copy R7 to buffer (Channel B)

0805 : 75 3E 00			mov		Wait_Data_B,#000H
0808 : 75 3D 00			mov		Field2_B,#000H
080B : 75 64 00			mov		Rx_Index_B,#000H
080E				L080E:
080E : D0 D0			pop		psw
0810 : D0 83			pop		dph
0812 : D0 82			pop		dpl
0814 : D0 E0			pop		acc
0816 : 32				reti